/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.metrics;

import java.io.IOException;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geo.search.aggregations.metrics.GeoBounds;
import org.opensearch.search.aggregations.ParsedAggregation;

public class ParsedGeoBounds
extends ParsedAggregation
implements GeoBounds {
    @Nullable
    private GeoBoundingBox geoBoundingBox;
    private static final ObjectParser<ParsedGeoBounds, Void> PARSER = new ObjectParser(ParsedGeoBounds.class.getSimpleName(), true, ParsedGeoBounds::new);
    private static final ConstructingObjectParser<Tuple<GeoPoint, GeoPoint>, Void> BOUNDS_PARSER = new ConstructingObjectParser(ParsedGeoBounds.class.getSimpleName() + "_BOUNDS", true, args -> new Tuple((Object)((GeoPoint)args[0]), (Object)((GeoPoint)args[1])));
    private static final ObjectParser<GeoPoint, Void> GEO_POINT_PARSER = new ObjectParser(ParsedGeoBounds.class.getSimpleName() + "_POINT", true, GeoPoint::new);

    public String getType() {
        return "geo_bounds";
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.geoBoundingBox != null) {
            this.geoBoundingBox.toXContent(builder, params);
        }
        return builder;
    }

    @Override
    @Nullable
    public GeoPoint topLeft() {
        return this.geoBoundingBox != null ? this.geoBoundingBox.topLeft() : null;
    }

    @Override
    @Nullable
    public GeoPoint bottomRight() {
        return this.geoBoundingBox != null ? this.geoBoundingBox.bottomRight() : null;
    }

    public static ParsedGeoBounds fromXContent(XContentParser parser, String name) {
        ParsedGeoBounds geoBounds = (ParsedGeoBounds)PARSER.apply(parser, null);
        geoBounds.setName(name);
        return geoBounds;
    }

    static {
        ParsedGeoBounds.declareAggregationFields(PARSER);
        PARSER.declareObject((agg, bbox) -> {
            agg.geoBoundingBox = new GeoBoundingBox((GeoPoint)bbox.v1(), (GeoPoint)bbox.v2());
        }, BOUNDS_PARSER, GeoBoundingBox.BOUNDS_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), GEO_POINT_PARSER, GeoBoundingBox.TOP_LEFT_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), GEO_POINT_PARSER, GeoBoundingBox.BOTTOM_RIGHT_FIELD);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLat, GeoBoundingBox.LAT_FIELD);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLon, GeoBoundingBox.LON_FIELD);
    }
}

