/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import javax.el.ELClass;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.el.VariableMapper;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.AstValue;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.Validation;

public final class AstIdentifier
extends SimpleNode {
    public AstIdentifier(int n) {
        super(n);
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        Object object;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (object = variableMapper.resolveVariable(this.image)) != null) {
            return object.getType(evaluationContext.getELContext());
        }
        evaluationContext.setPropertyResolved(false);
        object = evaluationContext.getELResolver().getType((ELContext)evaluationContext, null, (Object)this.image);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object object;
        if (evaluationContext.isLambdaArgument(this.image)) {
            return evaluationContext.getLambdaArgument(this.image);
        }
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (object = variableMapper.resolveVariable(this.image)) != null) {
            return object.getValue(evaluationContext.getELContext());
        }
        evaluationContext.setPropertyResolved(false);
        if (this.parent instanceof AstValue) {
            evaluationContext.putContext(this.getClass(), Boolean.FALSE);
        } else {
            evaluationContext.putContext(this.getClass(), Boolean.TRUE);
        }
        try {
            object = evaluationContext.getELResolver().getValue((ELContext)evaluationContext, null, (Object)this.image);
        }
        finally {
            evaluationContext.putContext(this.getClass(), Boolean.FALSE);
        }
        if (evaluationContext.isPropertyResolved()) {
            return object;
        }
        object = evaluationContext.getImportHandler().resolveClass(this.image);
        if (object != null) {
            return new ELClass((Class)object);
        }
        object = evaluationContext.getImportHandler().resolveStatic(this.image);
        if (object != null) {
            try {
                return ((Class)object).getField(this.image).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                throw new ELException((Throwable)exception);
            }
        }
        throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
    }

    @Override
    public boolean isReadOnly(EvaluationContext evaluationContext) throws ELException {
        ValueExpression valueExpression;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (valueExpression = variableMapper.resolveVariable(this.image)) != null) {
            return valueExpression.isReadOnly(evaluationContext.getELContext());
        }
        evaluationContext.setPropertyResolved(false);
        boolean bl = evaluationContext.getELResolver().isReadOnly((ELContext)evaluationContext, null, (Object)this.image);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
        return bl;
    }

    @Override
    public void setValue(EvaluationContext evaluationContext, Object object) throws ELException {
        ValueExpression valueExpression;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (valueExpression = variableMapper.resolveVariable(this.image)) != null) {
            valueExpression.setValue(evaluationContext.getELContext(), object);
            return;
        }
        evaluationContext.setPropertyResolved(false);
        evaluationContext.getELResolver().setValue((ELContext)evaluationContext, null, (Object)this.image, object);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
    }

    @Override
    public Object invoke(EvaluationContext evaluationContext, Class<?>[] classArray, Object[] objectArray) throws ELException {
        return this.getMethodExpression(evaluationContext).invoke(evaluationContext.getELContext(), objectArray);
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext evaluationContext, Class<?>[] classArray) throws ELException {
        return this.getMethodExpression(evaluationContext).getMethodInfo(evaluationContext.getELContext());
    }

    @Override
    public void setImage(String string) {
        if (!Validation.isIdentifier(string)) {
            throw new ELException(MessageFactory.get("error.identifier.notjava", string));
        }
        this.image = string;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext evaluationContext) {
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper == null) {
            return null;
        }
        ValueExpression valueExpression = variableMapper.resolveVariable(this.image);
        if (valueExpression == null) {
            return null;
        }
        return valueExpression.getValueReference((ELContext)evaluationContext);
    }

    private MethodExpression getMethodExpression(EvaluationContext evaluationContext) throws ELException {
        Object object = null;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        ValueExpression valueExpression = null;
        if (variableMapper != null && (valueExpression = variableMapper.resolveVariable(this.image)) != null) {
            object = valueExpression.getValue((ELContext)evaluationContext);
        }
        if (valueExpression == null) {
            evaluationContext.setPropertyResolved(false);
            object = evaluationContext.getELResolver().getValue((ELContext)evaluationContext, null, (Object)this.image);
        }
        if (object instanceof MethodExpression) {
            return (MethodExpression)object;
        }
        if (object == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.identifier.noMethod", this.image));
        }
        throw new ELException(MessageFactory.get("error.identifier.notMethodExpression", this.image, object.getClass().getName()));
    }
}

