/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.netbeans.modules.progress.spi.ExtractedProgressUIWorker;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.ui.StatusLineComponent;

public class NbProgressBar
extends JProgressBar
implements ExtractedProgressUIWorker {
    static final String SLEEPY = "sleepy";
    boolean isSetup = false;
    boolean usedInStatusBar = false;
    private JLabel detailLabel = new JLabel();
    private JLabel mainLabel = new JLabel();

    public NbProgressBar() {
        Color color;
        this.setOrientation(0);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        Color color2 = UIManager.getColor("nbProgressBar.Foreground");
        if (color2 != null) {
            this.setForeground(color2);
        }
        if ((color = UIManager.getColor("nbProgressBar.Background")) != null) {
            this.setBackground(color);
        }
    }

    public void setUseInStatusBar(boolean bl) {
        this.usedInStatusBar = bl;
        if (UIManager.getLookAndFeel().getID().startsWith("FlatLaf")) {
            this.putClientProperty("JProgressBar.largeHeight", bl ? Boolean.valueOf(true) : null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.usedInStatusBar) {
            dimension.width = 200;
        }
        return dimension;
    }

    public void processProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getType() == 0 || !this.isSetup || progressEvent.isSwitched()) {
            NbProgressBar.setupBar(progressEvent.getSource(), this);
            this.mainLabel.setText(progressEvent.getSource().getDisplayName());
            this.isSetup = true;
        }
        if (progressEvent.getType() == 1) {
            if (progressEvent.getWorkunitsDone() > 0) {
                this.setValue(progressEvent.getWorkunitsDone());
            }
            this.setString(StatusLineComponent.getBarString(progressEvent.getPercentageDone(), progressEvent.getEstimatedCompletion()));
            if (progressEvent.getDisplayName() != null) {
                this.mainLabel.setText(progressEvent.getDisplayName());
            }
            if (progressEvent.getMessage() != null) {
                this.detailLabel.setText(progressEvent.getMessage());
            }
        } else if (progressEvent.getType() == 4) {
            boolean bl = this.isIndeterminate();
            this.setIndeterminate(false);
            this.setMaximum(progressEvent.getSource().getTotalUnits());
            this.setValue(progressEvent.getSource().getTotalUnits());
            if (bl) {
                this.setStringPainted(false);
            } else {
                this.setString(StatusLineComponent.getBarString(100.0, -1L));
            }
        }
    }

    public void processSelectedProgressEvent(ProgressEvent progressEvent) {
    }

    static void setupBar(InternalHandle internalHandle, NbProgressBar nbProgressBar) {
        nbProgressBar.putClientProperty(SLEEPY, null);
        int n = internalHandle.getTotalUnits();
        if (internalHandle.isInSleepMode()) {
            nbProgressBar.setStringPainted(true);
            nbProgressBar.setIndeterminate(false);
            nbProgressBar.setMaximum(1);
            nbProgressBar.setMinimum(0);
            nbProgressBar.setValue(0);
            nbProgressBar.putClientProperty(SLEEPY, new Object());
        } else if (n < 1) {
            nbProgressBar.setValue(nbProgressBar.getMaximum());
            nbProgressBar.setIndeterminate(true);
            nbProgressBar.setStringPainted(false);
        } else {
            nbProgressBar.setStringPainted(true);
            nbProgressBar.setIndeterminate(false);
            nbProgressBar.setMaximum(n);
            nbProgressBar.setMinimum(0);
            nbProgressBar.setValue(0);
        }
        nbProgressBar.setString(" ");
    }

    public JComponent getProgressComponent() {
        return this;
    }

    public JLabel getMainLabelComponent() {
        return this.mainLabel;
    }

    public JLabel getDetailLabelComponent() {
        return this.detailLabel;
    }
}

